/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.problem;

import com.ibm.hwmca.base.pa.system.ConsoleSystem;
import com.ibm.hwmca.base.pa.vr.VirtualRetainManager;
import com.ibm.hwmca.fw.pa.config.ProblemManagerData;
import com.ibm.hwmca.fw.pa.fedc.FEDCCollectionAgent;
import com.ibm.hwmca.fw.pa.fedc.FEDCKey;
import com.ibm.hwmca.fw.pa.persist.PersistenceNotInitializedException;
import com.ibm.hwmca.fw.pa.persist.ProblemPersistenceException;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemAlreadyRegisteredException;
import com.ibm.hwmca.fw.pa.problem.ProblemClosingException;
import com.ibm.hwmca.fw.pa.problem.ProblemNotRegisteredException;
import com.ibm.hwmca.fw.pa.problem.ProblemOpeningException;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventAlreadyRegisteredException;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventManager;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventNotRegisteredException;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventPersistenceException;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventPersistenceNotInitializedException;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.fedc.FEDCFileDescriptor;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.util.CommonPaLogger;
import com.ibm.hwmca.xfw.pa.util.CommonPaUtils;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProblemManager
extends ServiceableEventManager {
    private static final String TRACE_MASKT = "XPAPROMT";
    private static final String TRACE_MASKF = "XPAPROMF";
    private static final String TRACE_MASKD = "XPAPROMD";
    public static final String PROPERTY_PROBLEM_PREFIX = "Problem";
    public static final int WRAP_LIMIT = 9999;
    public static final String PROPERTY_PROBLEM_INVENTORY = "ProblemInventoryProperty";
    public static final String PROPERTY_PROBLEM_CLOSE = "ProblemCloseProperty";
    public static final String PROPERTY_PROBLEM_SECONDARY_CLOSE = "ProblemSecondaryCloseProperty";
    public static final String PROPERTY_PROBLEM_OPEN = "ProblemOpenProperty";
    public static final String PROPERTY_PROBLEM_CHANGED = "ProblemChangedProperty";
    private static ProblemManager problemManager = null;
    private static boolean problemsLoaded = false;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$pa$problem$ProblemManager;

    private ProblemManager() {
    }

    public static synchronized ProblemManager getProblemManager() throws PersistenceNotInitializedException, ProblemPersistenceException {
        Trace.trace(TRACE_MASKD, "-> ProblemManager.getProblemManager()");
        if (problemManager == null) {
            Trace.trace(TRACE_MASKD, "<-! ProblemManager.getProblemManager() No persistence what so ever?");
            throw new PersistenceNotInitializedException("No persistence what so ever?");
        }
        if (!problemsLoaded) {
            Trace.trace(TRACE_MASKD, "loading problems");
            try {
                problemManager.loadServiceableEvents();
                problemManager.calculateNextProblemNumber();
            }
            catch (ServiceableEventPersistenceException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.getProblemManager: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new ProblemPersistenceException(e);
            }
            catch (ServiceableEventPersistenceNotInitializedException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.getProblemManager: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new PersistenceNotInitializedException(e);
            }
            finally {
                problemsLoaded = true;
            }
        }
        Trace.trace(TRACE_MASKD, "<- ProblemManager.getProblemManager()");
        return problemManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfigData(ProblemManagerData configData) throws PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKD, "--> ProblemManager.setConfigData");
        Class clazz = class$com$ibm$hwmca$fw$pa$problem$ProblemManager == null ? (class$com$ibm$hwmca$fw$pa$problem$ProblemManager = ProblemManager.class$("com.ibm.hwmca.fw.pa.problem.ProblemManager")) : class$com$ibm$hwmca$fw$pa$problem$ProblemManager;
        synchronized (clazz) {
            if (problemManager == null) {
                problemManager = new ProblemManager();
            }
        }
        try {
            problemManager.addPersistenceConfigData(configData);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.setConfigData: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        Trace.trace(TRACE_MASKD, "<-- ProblemManager.setConfigData");
    }

    public static void reLoadPersistedProblems(ProblemManager ourManager) throws ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKD, "-> ProblemManager.reLoadPersistedProblems()");
        Trace.trace(TRACE_MASKD, "loading problems");
        try {
            ourManager.loadServiceableEvents();
            ourManager.calculateNextProblemNumber();
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.reLoadPersistedProblems: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemPersistenceException(e);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.reLoadPersistedProblems: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        finally {
            problemsLoaded = true;
        }
        Trace.trace(TRACE_MASKD, "<- ProblemManager.reloadPersistedProblems()");
    }

    public Problem getProblem(String key) {
        return (Problem)super.getServiceableEvent(key);
    }

    public List getAllProblems() {
        ArrayList myArrayList = new ArrayList();
        myArrayList.addAll(super.getAllServiceableEvents());
        return (List)myArrayList.clone();
    }

    public synchronized void addProblem(Problem problem) throws ProblemAlreadyRegisteredException, PersistenceNotInitializedException, ProblemPersistenceException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.addProblem problem[" + problem + "]");
        try {
            super.add(problem);
            if (problem instanceof CommonProblem && ((CommonProblem)problem).getProblemDataSet() != null) {
                Iterator ePDD = ((CommonProblem)problem).getProblemDataSet().iterator();
                String uniqueKey = problem.getDuplicateOf();
                CommonProblem masterP = (CommonProblem)this.getProblem(uniqueKey);
                while (ePDD.hasNext()) {
                    Trace.trace(TRACE_MASKT, "-> adding ProblemDataDescriptor from add problem to master");
                    masterP.addProblemDataSet((ProblemDataDescriptor)ePDD.next());
                }
                try {
                    ProblemManager.getProblemManager().changed(masterP);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "got a pm exception");
                    Trace.trace(TRACE_MASKF, e);
                }
            }
            this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_INVENTORY, null, problem);
        }
        catch (ServiceableEventAlreadyRegisteredException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.addProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemAlreadyRegisteredException(e);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.addProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.addProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.addProblem");
    }

    public synchronized void removeProblem(Problem problem) throws ProblemNotRegisteredException, ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.removeProblem problem[" + problem + "]");
        Problem p = (Problem)super.getServiceableEvent(problem.getUniqueKey());
        if (p == null) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.removeProblem: Specified problem did not exist");
            throw new ProblemNotRegisteredException("Specified problem did not exist");
        }
        try {
            super.remove(p);
            this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_INVENTORY, null, p);
        }
        catch (ServiceableEventNotRegisteredException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.removeProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemNotRegisteredException(e);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.removeProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.removeProblem: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.removeProblem");
    }

    public synchronized void open(Problem problem) throws PropertyVetoException, ProblemOpeningException, ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.open problem[" + problem + "]");
        boolean alreadyAdded = false;
        if (this.serviceableEvents.contains(problem)) {
            alreadyAdded = true;
        }
        if (problem.isVetoable()) {
            this.vetoChangeSupport.fireVetoableChange(PROPERTY_PROBLEM_OPEN, problem, null);
        } else {
            Trace.trace(TRACE_MASKF, "this problem doesn't allow vetos");
        }
        problem.open();
        problem.assignProblemNumber();
        problem.setProblemState(1);
        if (!alreadyAdded) {
            try {
                super.add(problem);
                this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_INVENTORY, null, problem);
            }
            catch (ServiceableEventAlreadyRegisteredException e) {
            }
            catch (ServiceableEventPersistenceNotInitializedException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.open: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new PersistenceNotInitializedException(e);
            }
            catch (ServiceableEventPersistenceException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.open: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new ProblemPersistenceException(e);
            }
        } else {
            try {
                super.getServiceableEventPersistence(problem.getClass()).store(problem);
            }
            catch (ServiceableEventPersistenceNotInitializedException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.open: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new PersistenceNotInitializedException(e);
            }
            catch (ServiceableEventPersistenceException e) {
                Trace.trace(TRACE_MASKT, "<-! ProblemManager.open: Exception");
                Trace.trace(TRACE_MASKT, e);
                throw new ProblemPersistenceException(e);
            }
        }
        this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_OPEN, problem, null);
        Trace.trace(TRACE_MASKT, "<- ProblemManager.open");
    }

    public synchronized void changed(Problem problem) throws ProblemNotRegisteredException, PersistenceNotInitializedException, ProblemPersistenceException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.changed problem[" + problem + "]");
        Problem p = (Problem)super.getServiceableEvent(problem.getUniqueKey());
        if (p == null || p != problem) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.changed: Specified problem did not exist/may have been replaced");
            throw new ProblemNotRegisteredException("Specified problem did not exist/may have been replaced");
        }
        try {
            super.changed(p);
            this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_CHANGED, p, null);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.changed: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.changed: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.changed");
    }

    public synchronized void secondaryChanged(Problem problem) throws ProblemNotRegisteredException, PersistenceNotInitializedException, ProblemPersistenceException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.secondaryChanged problem[" + problem + "]");
        Problem p = (Problem)super.getServiceableEvent(problem.getUniqueKey());
        if (p == null) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryChanged: Specified problem did not exist");
            throw new ProblemNotRegisteredException("Specified problem did not exist");
        }
        try {
            this.serviceableEvents.remove(p);
            this.getServiceableEventPersistence(p.getClass()).remove(p);
            this.serviceableEvents.add(problem);
            super.changed(problem);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryChanged: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryChanged: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.secondaryChanged");
    }

    public synchronized void close(Problem problem) throws ProblemNotRegisteredException, PropertyVetoException, ProblemClosingException, ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.close problem[" + problem + "]");
        if (problem instanceof CommonProblem && DistributedAnalysisDomain.attemptProblemActionRedirection((CommonProblem)problem, "PART_DAD_PROB_CLOSE")) {
            Trace.trace(TRACE_MASKT, "<-- ProblemManager.close()");
            return;
        }
        this.primaryClose(problem);
        Trace.trace(TRACE_MASKT, "<- ProblemManager.close");
    }

    public synchronized void primaryClose(Problem problem) throws ProblemNotRegisteredException, PropertyVetoException, ProblemClosingException, ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.primaryClose problem[" + problem + "]");
        Problem p = (Problem)super.getServiceableEvent(problem.getUniqueKey());
        if (p == null || p != problem) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.primaryClose: Specified problem did not exist/may have been replaced");
            throw new ProblemNotRegisteredException("Specified problem did not exist/may have been replaced");
        }
        try {
            if (p.isVetoable()) {
                this.vetoChangeSupport.fireVetoableChange(PROPERTY_PROBLEM_CLOSE, p, null);
            } else {
                Trace.trace(TRACE_MASKF, "this problem doesn't allow vetos");
            }
            p.close();
            p.setProblemState(2);
            super.changed(p);
            this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_CLOSE, p, null);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.primaryClose: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.primaryClose: Exception");
            Trace.trace(TRACE_MASKT, e);
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.primaryClose");
    }

    public synchronized void secondaryClose(Problem problem) throws ProblemNotRegisteredException, ProblemClosingException, ProblemPersistenceException, PersistenceNotInitializedException {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.secondaryClose problem[" + problem + "]");
        Problem p = (Problem)super.getServiceableEvent(problem.getUniqueKey());
        if (p == null) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryClose: specified problem did not exist");
            throw new ProblemNotRegisteredException("ProblemManager.secondaryClose: specified problem did not exist");
        }
        try {
            p.close();
            p.setProblemState(2);
            super.changed(p);
            this.propertyChangeSupport.firePropertyChange(PROPERTY_PROBLEM_SECONDARY_CLOSE, p, null);
        }
        catch (ServiceableEventPersistenceNotInitializedException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryClose exception caught:[" + e + "]");
            throw new PersistenceNotInitializedException(e);
        }
        catch (ServiceableEventPersistenceException e) {
            Trace.trace(TRACE_MASKT, "<-! ProblemManager.secondaryClose exception caught:[" + e + "]");
            throw new ProblemPersistenceException(e);
        }
        Trace.trace(TRACE_MASKT, "<- ProblemManager.secondaryClose");
    }

    private void calculateNextProblemNumber() {
        Trace.trace(TRACE_MASKT, "-> ProblemManager.calculateNextProblemNumber()");
        List problems = this.getAllServiceableEvents();
        int nextProblem = 0;
        ArrayList<Integer> problemNumbers = new ArrayList<Integer>();
        ConsoleSystem thisConsole = new ConsoleSystem();
        Iterator iterator = problems.iterator();
        while (iterator.hasNext()) {
            PASystem system;
            Problem prob = (Problem)iterator.next();
            if (prob instanceof CommonProblem && (system = ((CommonProblem)prob).getPrimaryAnalyzingConsoleSystem()) != null && !thisConsole.equals(system)) {
                Trace.trace(TRACE_MASKF, "problem from other console; not considering number " + prob.getProblemNumber());
                continue;
            }
            int number = prob.getProblemNumber();
            problemNumbers.add(new Integer(number));
            nextProblem = Math.max(nextProblem, number);
        }
        if (++nextProblem > 9999) {
            Trace.trace(TRACE_MASKF, "next number is over wrap limit: " + nextProblem);
            nextProblem = 1;
            while (problemNumbers.contains(new Integer(nextProblem))) {
                Trace.trace(TRACE_MASKF, "number already in use: " + nextProblem);
                ++nextProblem;
            }
        }
        Trace.trace(TRACE_MASKD, "setting NEXT problem number to " + nextProblem);
        Problem.setNextProblemNumber(nextProblem);
        Trace.trace(TRACE_MASKT, "<- ProblemManager.calculateNextProblemNumber()");
    }

    public void registerListenersBeforeCPL() {
    }

    public void registerListenersAfterCPL() {
    }

    private void collectEED(CommonProblem theProblem) {
        FEDCCollectionAgent agent = null;
        String serviceGoodie = "";
        String mclGoodie = "";
        String ffdcGoodie = "";
        String typeGoodie = "";
        boolean problemChanged = false;
        try {
            Trace.trace(TRACE_MASKF, "get the FFDC factory");
            agent = (FEDCCollectionAgent)ServiceInterfaces.getFactory(theProblem.getFailingSystem(), "FEDCCollectionFactory");
            Trace.trace(TRACE_MASKF, "now get the goodeis");
            List goodieList = agent.getGoodies(theProblem);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got a fedc collection exception");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKD, "problem.collectffedc is [" + theProblem.isCollectFFDC() + "]");
        Trace.trace(TRACE_MASKD, "ffdcGoodie is [" + ffdcGoodie + "]");
        if (theProblem.isCollectFFDC() && !ffdcGoodie.equals("N") && agent != null) {
            try {
                ProblemDataDescriptor pdd;
                VirtualRetainManager vr = VirtualRetainManager.getVirtualRetainManager();
                Integer problemNumber = new Integer(theProblem.getProblemNumber());
                String sProblemNumber = problemNumber.toString();
                problemChanged = true;
                Trace.trace(TRACE_MASKD, "Creating vr directory for " + sProblemNumber);
                String dirPath = vr.createDirectory(sProblemNumber);
                String zipAbsoluteName = vr.queryZipName(sProblemNumber);
                File zipFile = new File(zipAbsoluteName);
                String zipName = zipFile.getName();
                theProblem.setEEDLocation(zipAbsoluteName);
                Trace.trace(TRACE_MASKD, "they want to collect FFDC data");
                FEDCKey theKey = theProblem.getFEDCKey();
                Trace.trace(TRACE_MASKD, "execute any post analysis stuff");
                agent.postAnalysisExecuteModules(theProblem);
                Trace.trace(TRACE_MASKD, "get the files to call home");
                List fileList = agent.getResolvedFileList(theKey);
                List problemFileList = theProblem.getAssociatedFileList();
                if (problemFileList != null) {
                    CommonPaUtils.resolveFileList(problemFileList, fileList);
                }
                int fileCount = fileList.size();
                Trace.trace(TRACE_MASKD, "got " + fileCount + " files to call home");
                for (int i = 0; i < fileCount; ++i) {
                    FEDCFileDescriptor file = (FEDCFileDescriptor)fileList.get(i);
                    Trace.trace(TRACE_MASKD, "file info->" + file);
                }
                Trace.trace(TRACE_MASKD, "add the files");
                ArrayList<String> primaryFileList = new ArrayList<String>();
                ArrayList<String> secondaryFileList = new ArrayList<String>();
                for (int i = 0; i < fileCount; ++i) {
                    FEDCFileDescriptor element = (FEDCFileDescriptor)fileList.get(i);
                    if (element.type.equals("primary")) {
                        Trace.trace(TRACE_MASKD, "adding " + element + " to the primary list");
                        primaryFileList.add(element.name);
                        ProblemDataDescriptor primaryPdd = new ProblemDataDescriptor();
                        primaryPdd.setLocation(zipAbsoluteName);
                        primaryPdd.setName(element.name);
                        theProblem.addProblemDataSet(primaryPdd);
                        continue;
                    }
                    Trace.trace(TRACE_MASKD, "adding " + element + " to the secondary list");
                    secondaryFileList.add(element.name);
                    ProblemDataDescriptor secondaryPdd = new ProblemDataDescriptor();
                    secondaryPdd.setLocation(element.name);
                    secondaryPdd.setName(element.name);
                    theProblem.addProblemDataSet(secondaryPdd);
                }
                ArrayList failures = new ArrayList();
                if (primaryFileList.size() > 0) {
                    failures.addAll(vr.addToZip(sProblemNumber, primaryFileList, true, false));
                }
                if (secondaryFileList.size() > 0) {
                    failures.addAll(vr.copyToDirectory(sProblemNumber, secondaryFileList));
                }
                Iterator iter = theProblem.getProblemDataSet().iterator();
                while (iter.hasNext()) {
                    pdd = (ProblemDataDescriptor)iter.next();
                    if (failures.contains(pdd.getName())) {
                        Trace.trace(TRACE_MASKD, "setting errorWhileCollecting for " + pdd.getName() + " to true");
                        pdd.setErrorWhileCollecting(true);
                    }
                    if (pdd.isInZip()) continue;
                    Trace.trace(TRACE_MASKD, "adjusting PDD paths.  Before: " + pdd);
                    String name = pdd.getName();
                    pdd.setName(dirPath + name.substring(name.lastIndexOf("/") + 1));
                    name = pdd.getFileLocation();
                    pdd.setLocation(dirPath + name.substring(name.lastIndexOf("/") + 1));
                    Trace.trace(TRACE_MASKD, "adjusting PDD paths.  After: " + pdd);
                }
                Trace.trace(TRACE_MASKD, "the zip file name is " + zipAbsoluteName);
                Trace.trace(TRACE_MASKD, "add the vr data to the problem");
                problemChanged = true;
                pdd = new ProblemDataDescriptor();
                pdd.setLocation(zipAbsoluteName);
                pdd.setName(zipName);
                theProblem.addProblemDataSet(pdd);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "got an exception putting the data into VR");
                Trace.trace(TRACE_MASKF, e);
                CommonPaLogger.logIt((short)4113, 0, (Throwable)e, false);
            }
            Trace.trace(TRACE_MASKF, "running the clean-up routines");
            try {
                agent.cleanUpAnalysisExecuteModules(theProblem);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "got an exception putting the data into VR");
                Trace.trace(TRACE_MASKF, e);
            }
        } else {
            Trace.trace(TRACE_MASKF, "no ffdc to collect.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

